﻿/*
CREATES:
	EV onTileChange
	() runFunc
	
REQUIRES:
	eventSystem.as
	sendEvent.as
	"onMove" event
*/

function runFunc( func ){
	return func.apply( _this, arguments.slice() );
}// runFunc()


runFunc(function(){
	var mapTileSize = MAP.tileSize || 16;
	//var lastX = Math.floor(_x/mapTileSize);
	//var lastY = Math.floor(_y/mapTileSize);
	// assume you're starting on ???, so that tile-change will trigger upon initializing
	var lastX = -1;
	var lastY = -1;
	
	function onMove(){
		var xTile = Math.floor(_x/mapTileSize);
		var yTile = Math.floor(_y/mapTileSize);
		if(xTile != lastX  ||  yTile != lastY)
		{// if:  this sprite's tile-location has changed
			sendEvent("onTileChange", {
				previousTile: {x:lastX, y:lastY},
				currentTile: {x:xTile, y:yTile}
			});
		}// if:  this sprite's tile-location has changed
		lastX = xTile;
		lastY = yTile;
	}// onMove()
	
	react.to("onMove").then = onMove;
	react.to("onMoveFinish").then = onMove;		//  This is necessary because onMoveFinish => onMove doesn't reliably trigger "onTileChange" ... for some reason
	react.to("init").then = onMove;
});// onTileChange_obj